const fs = require('fs');
const https = require('https');

const app = require('./app');
const { port } = require('yandex-cfg').server;

const server = process.env.NODE_ENV === 'local' ? https.createServer({
    key: fs.readFileSync('server.key'),
    cert: fs.readFileSync('server.cert')
}, app) : app;

server.listen(port, err => {
    if (err) {
        return console.error(err);
    }

    console.log(`Server started on ${port}`);
});