var supervisor;
var scriptNode = document.getElementById('pro');
var data = scriptNode.dataset;
var methods = {
    create: function () {
        supervisor = new Supervisor({ url: data.proUrl });

        sendEvent('supervisor-ready');

        supervisor.on('metrics', function (e) {
            sendEvent('supervisor-metrics', e.metrics);
        });
    },

    init: function (token) {
        supervisor
            .init({
                token: token
            })
            .then(function () {
                sendEvent('supervisor-inited');
            })
            .catch(function (err) {
                sendEvent('supervisor-init-error', formatError(err));
            });
    },

    check: function (options) {
        supervisor
            .check(options)
            .catch(function (err) {
                if (err.name !== 'NoFace') {
                    throw new Error(err.name);
                }
            })
            .then(function () {
                sendEvent('supervisor-checked');
            })
            .catch(function (err) {
                sendEvent('supervisor-check-error', formatError(err));
            });
    },

    profile: function (options) {
        var file = base64ToFile(options.image, 'face.jpg');

        supervisor
            .profile({ face: file })
            .then(function () {
                sendEvent('supervisor-profile-saved');
            })
            .catch(function (err) {
                sendEvent('supervisor-profile-error', formatError(err));
            });
    },

    start: function () {
        supervisor
            .start()
            .then(function () {
                sendEvent('supervisor-started');
            })
            .catch(function (err) {
                sendEvent('supervisor-start-error', formatError(err));
            });
    },

    stop: function () {
        supervisor
            .stop()
            .then(function () {
                sendEvent('supervisor-stopped');
            })
            .catch(function (err) {
                sendEvent('supervisor-stop-error', formatError(err));
            });
    },

    getmedia: function () {
        navigator.mediaDevices.getUserMedia({ video: true, audio: true})
            .then(function () {
                sendEvent('getmedia-success')
            })
            .catch(function (err) {
                sendEvent('getmedia-error', formatError(err));
            });
    },

    resize: function (options) {
        window.outerWidth = options.outerWidth;
        window.outerHeight = options.outerHeight;
    }
};

function onResponse(data) {
    try {
        data = JSON.parse(data);
    } catch (error) {
        return;
    }

    if (!data.method || !methods[data.method]) {
        return;
    }

    methods[data.method].call(this, data.options);
}

function receiveMessage(e) {
    var xhr = new XMLHttpRequest();

    xhr.open('POST', '/access', true);
    xhr.setRequestHeader('Content-Type', 'application/json');
    xhr.send(JSON.stringify({ origin: e.origin }));

    xhr.onreadystatechange = function () {
        if (xhr.readyState !== 4 || xhr.status !== 200) {
            return;
        }

        this.onResponse(e.data);
    }.bind(this);
}

function sendEvent(event, payload) {
    var data = JSON.stringify({ event: event, payload: payload });
    parent.postMessage(data, '*');
}

function base64ToFile(dataurl, filename) {
    var arr = dataurl.split(',');
    var mime = arr[0].match(/:(.*?);/)[1];
    var bstr = atob(arr[1]);
    var n = bstr.length;
    var u8arr = new Uint8Array(n);

    while (n--) {
        u8arr[n] = bstr.charCodeAt(n);
    }
    return new File([u8arr], filename, { type: mime });
}

function formatError(err) {
    return err.name + ': ' + err.message;
}

window.onload = function () {
    window.addEventListener('message', receiveMessage);
    sendEvent('supervisor-iframe-ready');
};
