module.exports = {
    extends: './node_modules/@yandex-int/lint/eslintrc.js',
    rules: {
        quotes: [
            'error',
            'single',
            {
                avoidEscape: false,
                allowTemplateLiterals: false,
            },
        ],
        'linebreak-style': [
            'error',
            'unix',
        ],
        'no-inner-declarations': [
            'error',
            'functions',
        ],
        'new-cap': [
            'error',
            {
                newIsCap: true,
                capIsNew: true,
                newIsCapExceptions: [],
                capIsNewExceptions: [
                    'Boolean',
                    'Number',
                    'Object',
                    'String',
                    'Symbol',
                    'Event',
                    'Immutable.List',
                    'Immutable.Map',
                    'Immutable.OrderedMap',
                    'Immutable.Record',
                    'Immutable.Set',
                ],
                properties: true,
            },
        ],
        eqeqeq: [
            'error',
            'smart',
        ],
        'comma-style': [
            'error',
            'last',
        ],
        'semi-style': [
            'error',
            'last',
        ],
        'array-bracket-newline': [
            'error',
            'consistent',
        ],
        'no-unused-expressions': [
            'error',
            { allowShortCircuit: true },
        ],
        'newline-per-chained-call': [
            'error',
            {
                ignoreChainWithDepth: 3,
            },
        ],
        'max-nested-callbacks': [
            'error',
            {
                max: 4,
            },
        ],
        'switch-colon-spacing': [
            'error',
            {
                before: false,
                after: true,
            },
        ],
        'spaced-comment': [
            'error',
            'always',
            {
                block: {
                    balanced: true,
                },
            },
        ],
        'consistent-this': [
            'error',
            'self',
        ],
        'no-shadow-restricted-names': [
            'error',
        ],
        'object-property-newline': [
            'error',
            {
                allowAllPropertiesOnSameLine: true,
            },
        ],
        'computed-property-spacing': [
            'error',
            'never',
        ],
        'prefer-template': [
            'error',
        ],
        'template-curly-spacing': [
            'error',
            'never',
        ],
        'no-var': [
            'error',
        ],
        'no-empty-function': [
            'error',
        ],
        'no-shadow': [
            'error',
            {
                builtinGlobals: false,
                hoist: 'all',
                allow: [
                    'resolve',
                    'reject',
                    'req',
                    'res',
                    'next',
                    'ok',
                    'body',
                ],
            },
        ],
        'no-duplicate-imports': [
            'error',
        ],
        'multiline-ternary': [
            'error',
            'always-multiline',
        ],
        'arrow-spacing': [
            'error',
            {
                before: true,
                after: true,
            },
        ],
        'no-useless-computed-key': [
            'error',
        ],
        'object-shorthand': [
            'error',
            'always',
        ],
        'no-restricted-properties': [
            'error',
        ],
        'lines-around-comment': [
            'error',
            {
                beforeBlockComment: true,
                afterBlockComment: false,
                beforeLineComment: false,
                afterLineComment: false,
                allowBlockStart: true,
                allowBlockEnd: true,
                allowObjectStart: true,
                allowObjectEnd: true,
                allowArrayStart: true,
                allowArrayEnd: true,
            },
        ],
        'no-useless-return': [
            'error',
        ],
        'padding-line-between-statements': [
            'error',
            {
                blankLine: 'always',
                prev: '*',
                next: 'return',
            },
            {
                blankLine: 'always',
                prev: ['const', 'let', 'var'],
                next: '*',
            },
            {
                blankLine: 'any',
                prev: ['const', 'let', 'var'],
                next: ['const', 'let', 'var'],
            },
        ],
        radix: [
            'error',
        ],
        'prefer-arrow-callback': [
            'error',
        ],
        'no-extra-parens': [
            'error',
            'all',
            {
                nestedBinaryExpressions: false,
                ignoreJSX: 'multi-line',
            },
        ],
        complexity: [
            'error',
            6,
        ],
        'no-negated-condition': [
            'error',
        ],
        'consistent-return': [
            'error',
        ],

        'react/jsx-wrap-multilines': [
            'error',
            {
                declaration: 'parens-new-line',
                assignment: 'parens-new-line',
                return: 'parens-new-line',
                arrow: 'parens-new-line',
            },
        ],
        'react/jsx-curly-spacing': [
            'error',
            {
                when: 'never',
                children: true,
                allowMultiline: false,
            },
        ],
        'react/jsx-tag-spacing': [
            'error',
            {
                closingSlash: 'never',
                beforeSelfClosing: 'always',
                afterOpening: 'never',
                beforeClosing: 'never',
            },
        ],
        'react/jsx-closing-bracket-location': [
            'error',
            {
                nonEmpty: 'tag-aligned',
                selfClosing: 'tag-aligned',
            },
        ],
        'react/jsx-props-no-multi-spaces': [
            'error',
        ],
        'react/jsx-max-props-per-line': [
            'error',
            {
                maximum: 1,
                when: 'multiline',
            },
        ],
        'react/jsx-curly-brace-presence': [
            'error',
            {
                props: 'never',
                children: 'never',
            },
        ],
    },
};
