const tasks = arr => arr.join(' && ');

const getGitBranchCmd = 'git rev-parse --abbrev-ref HEAD';
const mainBranch = 'master';
const warnMsg = `
====================================
    Внимание! Коммит в ${mainBranch}!
====================================
`;

module.exports = {
    hooks: {
        'pre-commit': tasks([
            'npx --no-install lint-staged',
            `${getGitBranchCmd} | grep "${mainBranch}" > /dev/null && echo "${warnMsg}" || exit 0`,
        ]),
    },
};
