const {URL} = require('url');

function getTvmApi() {
    return new URL('/tvm',
        process.env.DEPLOY_TVM_TOOL_URL ||
        process.env.QLOUD_TVM_INTERFACE_ORIGIN ||
        'http://localhost:1'
    ).href;
}

module.exports = {
    "env_variable_prefix": "CATALOG_",
    "server": {
        "port": 80,
        "cert": "/app/YandexInternalRootCA.crt"
    },
    "api": {
        "blackbox": "https://blackbox.yandex.net/blackbox",
        "directory": "https://api-internal.directory.ws.yandex.net",
        "gendarme": "https://gendarme.mail.yandex.net",
        "dns": "https://prod.dns-hosting.ws.yandex.net/api/v1",
        "fouras": "https://fouras.mail.yandex.net",
        "setter": "https://setter.mail.yandex.net",
        "isearch": "https://bisearch-backend.tools.yandex-team.ru/api",
        "tvm": getTvmApi(),
    },
    "rum": {
        "service_id": "ru.connect.catalog.internal",
        "counter_url": ""
    },
    "ui": {
        "avatar": "https://avatars.mds.yandex.net/get-yapic/${id}/islands-${size}",
        "logo": "//yastatic.net/q/logoaas/v1/${text}.svg",
        "email": "//mail.yandex.ru/compose?to=${email}"
    },
    "passport": {
        "session": {
            "login": "https://passport.yandex.ru/auth?retpath=${retpath}",
            "logout": "https://passport.yandex.ru/passport?mode=embeddedauth&action=logout&uid=${uid}&yu=${yu}&retpath=${retpath}",
            "change": "https://passport.yandex.ru/passport?mode=embeddedauth&action=change_default&uid=${uid}&yu=${yu}&retpath=${retpath}",
            "add": "https://passport.yandex.ru/auth?mode=add-user&retpath=${retpath}",
            "update": "https://passport.yandex.ru/auth/update/?retpath=${retpath}",
            "password_change": "https://passport.yandex.ru/passport?mode=changepass&retpath=${retpath}"
        }
    },
    "csp": {
        "rules": {
            "default-src": "'none'",
            "frame-src": "forms.yandex.ru yasm.yandex-team.ru",
            "child-src": "forms.yandex.ru yasm.yandex-team.ru",
            "connect-src": "'self' yastatic.net mc.yandex.ru yasm.yandex-team.ru",
            "font-src": "'none'",
            "img-src": "'self' avatars.mds.yandex.net avatars.mdst.yandex.net yastatic.net mc.yandex.ru data:",
            "script-src": "'self' 'unsafe-eval' 'unsafe-inline' mc.yandex.ru yastatic.net",
            "style-src": "'self' 'unsafe-inline' yastatic.net"
        },
        "report": "https://csp.yandex.net/csp"
    },
    "headers": {
        "html": {
            "Content-Type": "text/html; charset=utf-8",
            "X-Frame-Options": "ALLOW-FROM https://forms.yandex.ru/",
            "X-Content-Type-Options": "nosniff",
            "X-XSS-Protection": "1;mode=block"
        }
    }
};
