const config = require('../config');

const SKIPPED_PATHS = [ '/__webpack_hmr' ];
const DEPRECATED_HOSTS = [ 'connect-dashboard.ws.yandex.ru' ];

function skipped(req, res, next) {
    return SKIPPED_PATHS.indexOf(req.path) === -1 ? next() : res.send();
}

function deprecated(req, res, next) {
    if (DEPRECATED_HOSTS.indexOf(req.hostname) === -1)
        return next();

    return res.render('deprecated_host', {
        title: 'Deprecated host',
        layout_id: 'deprecated_host',
        version: config.version
    });
}

module.exports = {
    skipped, deprecated
};
