const dns = require('../util/dns');
const layout = require('../util/layout');

const RECORD_TYPES = [
    'A', 'AAAA', 'MX', 'TXT', 'CNAME', 'NS', 'SRV', 'CAA'
];

module.exports = (req, res, next) => {
    const { domain, org_id: orgId } = req.params;

    dns.getRecords(req, domain, orgId)
        .then((data = {}) => {
            layout(req, res).render('dns', Object.assign(data, {
                org_id: orgId,
                RECORD_TYPES,
                domain
            }));
        })
        .catch(next);
};
