const getDetails = require('../util/org/getDetails');
const getAdmins = require('../util/org/getAdmins');
const preprocessOrganization = require('../util/org/preprocess');
const layout = require('../util/layout');

module.exports = (req, res, next) => {
    getDetails(req, res, { orgId: req.params.org_id, allowCache: true })
        .then(details => {
            return getAdmins(req, res)
                .then(admins => Object.assign(details || {}, { admins }));
        })
        .then(data => {
            layout(req, res).render(
                data.code === 'not_found' ? 'org_details' : 'org_admins',
                { org: preprocessOrganization(req, data) }
            );
        })
        .catch(next);
};
