const getDetails = require('../util/org/getDetails');
const getDomains = require('../util/org/getDomains');
const preprocessOrganization = require('../util/org/preprocess');
const layout = require('../util/layout');

module.exports = (req, res, next) => {
    getDetails(req, res, { orgId: req.params.org_id, allowCache: true })
        .then(details => {
            return getDomains(req, res)
                .then(domains => Object.assign(details, { domains }));
        })
        .then(data => {
            layout(req, res).render(
                data.code === 'not_found' ? 'org_details' : 'org_domains',
                { org: preprocessOrganization(req, data) }
            );
        })
        .catch(next);
};
