const getDetails = require('../util/org/getDetails');
const getFeatures = require('../util/org/getFeatures');
const preprocessOrganization = require('../util/org/preprocess');
const layout = require('../util/layout');

module.exports = (req, res, next) => {
    getDetails(req, res, { orgId: req.params.org_id, allowCache: true })
        .then(details => {
            return getFeatures(req, res)
                .then(features => Object.assign(details, { features }));
        })
        .then(data => {
            layout(req, res).render(
                data.code === 'not_found' ? 'org_details' : 'org_features',
                { org: preprocessOrganization(req, data) }
            );
        })
        .catch(next);
};
