const getDetails = require('../util/org/getDetails');
const getLicenses = require('../util/org/getLicenses');
const preprocessOrganization = require('../util/org/preprocess');
const layout = require('../util/layout');

/**
 * Обработчик роутов org_licenses (см. ~/config/routes.json)
 * @param {Express.Request} req
 * @param {Express.Response} res
 * @param {Express.NextFunction} next
 * @returns {void}
 */
module.exports = (req, res, next) => {
    const { org_id: orgId, service_slug: serviceSlug } = req.params;

    return Promise
        .all([
            getDetails(req, res, { orgId, allowCache: true }),
            getLicenses(req, orgId, serviceSlug),
        ])
        .then(([details, licenses]) => 
            layout(req, res)
                .render('org_licenses', {
                    slug: serviceSlug,
                    org: preprocessOrganization(req, {
                        ...details,
                        licenses: licenses.reverse(),
                    })
                }))
        .catch(next);
};
