const getDetails = require('../util/org/getDetails');
const getStaff = require('../util/org/getStaff');
const preprocessOrganization = require('../util/org/preprocess');
const layout = require('../util/layout');

module.exports = (req, res, next) => {
    getDetails(req, res, { orgId: req.params.org_id, allowCache: true })
        .then(details => {
            return getStaff(req, res)
                .then(staff => Object.assign(details, { staff }));
        })
        .then(data => {
            layout(req, res).render(
                data.code === 'not_found' ? 'org_details' : 'org_staff',
                { org: preprocessOrganization(req, data) }
            );
        })
        .catch(next);
};
