const getDetails = require('../util/org/getDetails');
const getTasks = require('../util/org/getTasks');
const preprocessOrganization = require('../util/org/preprocess');
const layout = require('../util/layout');

module.exports = (req, res, next) => {
    getDetails(req, res, { orgId: req.params.org_id, allowCache: true })
        .then(details => {
            return getTasks(req, res)
                .then(tasks => Object.assign(details, { tasks }));
        })
        .then(data => {
            layout(req, res).render(
                data.code === 'not_found' ? 'org_details' : 'org_tasks',
                { org: preprocessOrganization(req, data) }
            );
        })
        .catch(next);
};
