const { URL, URLSearchParams } = require('url');

module.exports = (req, res, next) => {
    // форсированный сброс страницы в урле query-параметром page=0;
    // например, при поиске по пользователям организации (DIR-6365)
    if (req.query.page === '0') {
        const nextUrl = new URL(req.params.base_path, `${req.protocol}://${req.get('host')}`);
        const nextQuery = new URLSearchParams(req.query);

        nextQuery.delete('page');
        nextUrl.search = nextQuery;

        return res.redirect(nextUrl.href);
    }

    req.context.basePath = req.params.base_path;
    req.context.page = Number(req.params.page);

    next();
};
