const { ServiceSlugMap, UrlSlugMap } = require('../config/route_maps');
const layout = require('../util/layout');

module.exports = (req, res, next) => {
    let { service_slug: serviceSlug } = req.params;
    let { query } = req.query;

    if (serviceSlug in ServiceSlugMap) {
        serviceSlug = ServiceSlugMap[serviceSlug];
    }

    if (query) {
        return res.redirect(`/services/${UrlSlugMap[serviceSlug] || serviceSlug}/resources/${query}/history`);
    }

    return layout(req, res).render('resource_search', {
        service_slug: serviceSlug
    });
};
