const fetch = require('node-fetch');
const config = require('../config');
const log = require('../util/common/log');

module.exports = (req, res, next) => {
    let requestUrl = `${config.api.directory}/admin/user/`;

    return log(fetch)(requestUrl, { method: 'get', headers: req.context.headers })
        .then(response => response.json())
        .then(response => {
            req.context.session = Object.assign(req.context.session || {}, response);
            next();
        })
        .catch(next);
};
