const _ = require('lodash');
const config = require('../config');
const random = require('../util/common/random');
const log = require('../util/common/log');

module.exports = (req, res, next) => {
    const requestId = random.getString(16);

    req.context = { config };

    req.context.headers = {
        'Content-Type': 'application/json',
        'x-request-id': requestId,
        'x-user-ip': req.ip || _.get(req, 'connection.remoteAddress') || '127.0.0.1'
    };

    req.headers['x-request-id'] = requestId;

    log(req);
    next();
};