const fs = require('fs-extra');
const path = require('path');
const babel = require('rollup-plugin-babel');
const resolve = require('rollup-plugin-node-resolve');
const commonjs = require('rollup-plugin-commonjs');
// const uglify = require('rollup-plugin-uglify');

fs.copySync(
    path.join(__dirname, './resources'),
    path.join(__dirname, './compiled/res')
);

const SHARED_OUTPUT_CONFIG = {
    format: 'iife',
    sourcemap: 'inline'
};

const SHARED_PLUGINS = [
    resolve({
        jsnext: true,
        main: true,
        browser: true
    }),
    commonjs(),
    babel({
        exclude: 'node_modules/**'
    })/*,
    (process.env.NODE_ENV === 'production' && uglify())*/
];

let config = [];

fs.readdirSync(path.join(__dirname, './scripts')).forEach(file => {
    if (/\.js$/.test(file)) {
        config.push({
            input: `scripts/${file}`,
            output: Object.assign({}, SHARED_OUTPUT_CONFIG, {
                file: `compiled/js/${file}`
            }),
            plugins: SHARED_PLUGINS
        });
    }
});

module.exports = config;