import dom from '../util/dom';

function update(form) {
    let recordType = form.querySelector('[name="type"]').value;

    [...form.querySelectorAll('[data-types]')].forEach(element => {
        dom.toggleAttribute(
            element, 'hidden',
            !element.dataset.types.split(' ').includes(recordType)
        );
    });
}

function render(form) {
    if (!form || form.dataset.activated) {
        return;
    }

    let typeSelect = form.querySelector('select[name="type"]');

    if (typeSelect) {
        typeSelect.addEventListener('change', () => { update(form); });
    }

    form.addEventListener('submit', event => {
        let stringsField = event.target.querySelector('[data-id="strings"]');
        let stringsValue = stringsField.querySelector('[type="text"]').value;

        if (stringsValue) {
            // значение поля rdata.strings TXT-записи преобразуем в массив из строк
            // длиной 255 символов, как определено в стандарте
            stringsField.querySelector('[type="hidden"]').value = JSON.stringify(
                stringsValue.match(/.{1,255}/g)
            );
        }
    });

    update(form);
    form.dataset.activated = true;
}

function renderAll() {
    [...document.querySelectorAll('form[data-id="edit_dns_record"]')]
        .forEach(render);
}

renderAll();

export default { render };