import dom from '../util/dom';

function update(form) {
    let subscriptionPlan = form.querySelector('select[name="subscription_plan"]').value;

    dom.toggleAttribute(
        form.querySelector('[data-id="paid_subscription_expiration_date"]'),
        'hidden', subscriptionPlan === 'free'
    );
}

function render(form) {
    if (!form || form.dataset.activated)
        return;

    form.querySelector('select[name="subscription_plan"]')
        .addEventListener('change', () => { update(form); });

    update(form);
    form.dataset.activated = true;
}

function renderAll() {
    Array.from(document.querySelectorAll('form[data-id="subscription_plan"]'))
        .forEach(render);
}

renderAll();

export default { render };