
function toggleAttribute(element, binaryAttribute, condition) {
    if (!element) return;

    if (condition) element.setAttribute(binaryAttribute, '');
    else element.removeAttribute(binaryAttribute);

    if (binaryAttribute === 'hidden') {
        // в hidden полях добавляем атрибут disabled,
        // чтобы предотвратить их передачу на сервер
        Array.from(element.querySelectorAll('[name], [required]'))
            .forEach(e => {
                if (condition) e.setAttribute('disabled', '');
                else e.removeAttribute('disabled');
            });
    }
}

export default { toggleAttribute };