import _ from 'lodash';

function pick(parent) {
    if (!parent)
        parent = document;
    else if (typeof parent === 'string')
        parent = document.querySelector(parent);

    if (!parent)
        return;

    let elements = {};

    Array.from(parent.querySelectorAll('[data-id]'))
        .forEach(element => {
            if (element.dataset.id)
                _.set(elements, element.dataset.id, element);
        });

    return elements;
}

export default { pick };