
function update(element) {
    if (!element)
        return;

    if (element.dataset.alt && /^label$/i.test(element.tagName))
        element.textContent = element.dataset.alt;

    if (!element.dataset.placeholder)
        return;

    if (/^select$/i.test(element.tagName)) {
        let placeholderElement = element.querySelector('option[disabled][hidden]');
        if (placeholderElement)
            placeholderElement.textContent = element.dataset.placeholder;
    }
    else element.setAttribute('placeholder', element.dataset.placeholder);
}

function updateAll(parent) {
    if (!parent)
        parent = document;
    else if (typeof parent === 'string')
        parent = document.querySelector(parent);

    if (!parent)
        return;

    // текст плейсхолдера по умолчанию до отработки js может содержать название поля и
    // описывать условия, когда нужно заполнять поле;
    // после отработки js условия заполнения поля будут обеспечиваться в js, поэтому
    // плейсхолдер можно сократить до более короткого - например, только до
    // названия поля из data-placeholder

    Array.from(parent.querySelectorAll('[data-placeholder], [data-alt]')).forEach(update);
}

export default { update, updateAll };