
function getVersion() {
    // будет читать и возвращать последнюю версию из ченджлога
    return '0.0.0';
}

function hasUpdates(req) {
    let registeredVersion = req.cookies['changelog_version'];
    return registeredVersion && registeredVersion !== getVersion();
}

const DAY = 24*3600*1000;

function register(res) {
    res.cookie('changelog_version', getVersion(), { maxAge: 180*DAY });
}

function notify(res) {
    res.cookie('changelog_notification', getVersion(), { maxAge: 3*DAY });
}

function dismissNotification(res) {
    res.clearCookie('changelog_notification');
}

module.exports = {
    getVersion, hasUpdates, register,
    notify, dismissNotification
};
