const _ = require('lodash');

const CACHE_OPTIONS = { maxAge: 300000 };

module.exports = {
    read, push, storeAll
};

function read(req, key, filter) {
    let cache;

    try { cache = JSON.parse(req.cookies[key]); }
    catch(e) { return; }

    if (cache && (!filter || _.isMatch(cache, filter)))
        return cache;
}

// складываем кэшируемые переменные в хранилище временных переменных,
// чтобы перед финальным рендерингом лэйаута записать их все вместе
// в куки-кэш вызовом .storeAll(res)
function push(req, res, key, data, pushedDataKeys) {
    if (!key || !data || !res)
        return data;

    if (!req.context.cache)
        req.context.cache = {};

    let cachedValue = JSON.stringify(
        pushedDataKeys ? _.pick(data, pushedDataKeys) : data
    );

    req.context.cache[key] = cachedValue;

    return data;
}

function storeAll(req, res) {
    if (!res || !req.context.cache)
        return;

    Object.keys(req.context.cache).forEach(key => {
        res.cookie(key, req.context.cache[key], CACHE_OPTIONS);
    });
}
