const _ = require('lodash');

function toCurl(url, options) {
    let method = _.get(options, 'method', 'GET').toUpperCase();
    let headers = _.get(options, 'headers', {});
    let data = _.get(options, 'body');

    let headerString = Object.keys(headers)
        .map(key => ` -H '${key}: ${headers[key]}'`)
        .join('');

    let dataString = data === undefined || data === null ? '' : ` -d ${data}`;

    return `-X ${method} '${url}'${headerString}${dataString}`;
}

module.exports = toCurl;
