const querystring = require('querystring');
const fetch = require('node-fetch');
const log = require('./common/log');

function getPartners(req, res, options) {
    let requestUrl = `${req.context.config.api.directory}/admin/partners/`;

    options = Object.assign({
        page: req.params.page
    }, options || {});

    requestUrl += '?' + querystring.stringify(options);

    return log(fetch)(requestUrl, { method: 'get', headers: req.context.headers })
        .then(response => response.json())
        .catch(error => {});
}

module.exports = getPartners;
