const { URL } = require('url');
const fetch = require('node-fetch');
const log = require('./common/log');

module.exports = (req, res, { id, serviceSlug }) => {
    let url = new URL(`${req.context.config.api.directory}/admin/resources/history`);

    url.searchParams.append('resource_id', id);
    url.searchParams.append('service_slug', serviceSlug);
    url.searchParams.append('per_page', 20);

    if (req.params.page) {
        url.searchParams.append('page', req.params.page);
    }

    return log(fetch)(url.href, { method: 'get', headers: req.context.headers })
        .then(response => response.json())
        .catch(error => {});
}
