const fetch = require('node-fetch');
const log = require('./common/log');

function getUserDetails(req, res, userId) {
    if (!userId) return Promise.resolve();

    let requestUrl = `${req.context.config.api.directory}/admin/users/${userId}/`;

    return log(fetch)(requestUrl, { method: 'get', headers: req.context.headers })
        .then(response => response.json())
        .catch(error => {});
}

module.exports = getUserDetails;
