var _ = require('lodash');
var template = require('../common/template');
var encodeHtml = require('../common/encodeHtml');
var config = require('../../config');

function email_link(email, content) {
    if (!email) {
        return '';
    }

    var emailTemplate = _.get(config, 'ui.email');
    var link;

    if (emailTemplate) {
        link = template.build(emailTemplate, { email: encodeURIComponent(email) });
    }
    else {
        link = 'mailto:' + email;
    }

    if (typeof content !== 'string') {
        content = email;
    }

    return `<a href="${link}" rel="noopener noreferrer">${encodeHtml(content)}</a>`;
}

function html_email(email) {
    if (!email) {
        return '';
    }

    var parts = email.split('@');

    return (
        `<span class="email">` +
            `<span class="name">${parts[0]}</span>` +
            `<span class="joiner">@</span>` +
            `<span class="domain">${parts[1]}</span>` +
        `</span>`
    );
}

module.exports = {
    email_link, html_email
};
