var record = require('../record');

module.exports = {
    compound_name,
    safe_name,
    nonbreaking_safe_name
};

function compound_name(data, options) {
    return record.getCompoundName(data, options);
}

function safe_name(data) {
    return record.getSafeName(data);
}

// с неразбиваемыми дефисами
function nonbreaking_safe_name(data) {
    return record.getSafeName(data).replace(/\-/g, '\u2011');
}
