var _ = require('lodash');
var i18nUtil = require('../common/i18n');

module.exports = {
    i18n, i18n_raw, pluralize
};

// с опциональными параметрами и заполнением плейсхолдеров
function i18n(...args) {
    var options = args[args.length - 1];
    var dictionary = i18nUtil.getDictionary(options);
    return dictionary.pick(args.slice(0, -1).join(''), options.hash.data || options.hash);
}

// как есть, без параметров и заполнения плейсхолдеров
function i18n_raw(...args) {
    var options = args[args.length - 1];
    var dictionary = i18nUtil.getDictionary(options);
    return _.get(dictionary.storage, args.slice(0, -1).join(''));
}

function pluralize(...args) {
    var options = args[args.length - 1];
    var dictionary = i18nUtil.getDictionary(options);
    return dictionary.pluralize.apply(dictionary, args.slice(0, -1));
}
