var i18n = require('../common/i18n');
var encodeHtml = require('../common/encodeHtml');

function status_message(data, options) {
    if (!data) {
        return '';
    }

    if (data.content) {
        return data.content;
    }

    var dictionary = i18n.getDictionary(options);
    var humanReadableMessage;
    var technicalMessage;

    if (data.query) {
        humanReadableMessage = dictionary.pick(`api_errors.${data.query.key}.${data.query.code}`);
        technicalMessage = `${data.query.type} ${data.query.status} — ${data.query.key}: ${data.query.code}`;
    }

    return encodeHtml(humanReadableMessage || technicalMessage) || '';
}

module.exports = {
    status_message
};
