var i18n = require('../common/i18n');

function service_name(slug, options) {
    var dictionary = i18n.getDictionary(options);
    return (
        dictionary.pick('service_details.name.' + slug) ||
        String(slug).split(/[\-_ ]+/).map(value => {
            return value.charAt(0).toUpperCase() + value.substring(1);
        }).join(' ')
    );
}

module.exports = {
    service_name
};
