
module.exports = {
    linebreaking_utm_source,
    utm_source_components
};

function linebreaking_utm_source(source) {
    return (source || '').split('|').join('|<wbr>');
}

function utm_source_components(source) {
    var components = (source || '').split('|');

    if (components.length === 1 && components[0].indexOf('=') === -1) {
        return null;
    }

    return components.map(component => {
        var subcomponents = component.split('=');

        if (subcomponents.length === 1) {
            return { value: subcomponents[0] };
        }
        else {
            return { key: subcomponents[0], value: subcomponents[1] };
        }
    });
}
