const template = require('../common/template');
const common = require('./common');

module.exports = {
    pluralize,
    formatNumber,
    formatCurrency
};

const PLURALIZATION_PATTERN = '${number}\u00a0${objects}';
const DATE_PATTERN = '${month}\u00a0${date},\u00a0${year}';

const NUMBER_FORMAT = {
    digitGroup: { size: 3, delimiter: ',' },
    fraction: { delimiter: '.' }
};

const CURRENCY_PATTERNS = {
    RUB: '${amount}\u00a0\u20bd',
    USD: '$\u2009${amount}'
};

const MONTHS = [
    'January', 'February', 'March', 'April', 'May', 'June',
    'July', 'August', 'September', 'October', 'November', 'December'
];

// forms: [ one, many ]
function pluralize(number, forms, pattern) {
    if (!pattern) pattern = PLURALIZATION_PATTERN;

    let form = forms instanceof Array ? forms[Math.abs(number) === 1 ? 0 : 1] : forms;
    
    return template.build(pattern, {
        number: formatNumber(number), objects: form
    });
}

// 12345.6789 > '12,345.6789'
function formatNumber(value, type) {
    return common.formatNumber(value, NUMBER_FORMAT, type);
}

function formatCurrency(amount, currency) {
    if (!CURRENCY_PATTERNS[currency])
        return currency + '\u00a0' + formatNumber(amount, 'currency');

    return template.build(CURRENCY_PATTERNS[currency], {
        amount: formatNumber(amount, 'currency')
    });
}
