const _ = require('lodash');
const getDetails = require('./getDetails');
const getAdmins = require('./getAdmins');

function addListDetails(req, res, data) {
    if (!data) return data;

    let orgDetails = (data.result || []).map(item => {
        return getDetails(req, res, { orgId: item.id })
            .then(response => _.merge(item, response));
    });

    let adminDetails = (data.result || []).map(item => {
        return getAdmins(req, res, item.id)
            .then(response => _.merge(item, { admins: response }));
    });

    return Promise.all(orgDetails)
        .then(() => Promise.all(adminDetails))
        .then(() => data);
}

module.exports = addListDetails;
