const querystring = require('querystring');
const fetch = require('node-fetch');
const log = require('../common/log');

function getActions(req, res, orgId) {
    let requestUrl = `${req.context.config.api.directory}/admin/organizations/${orgId || req.params.org_id}/actions/`;

    let options = {
        page: req.params.page,
        ordering: '-revision'
    };

    requestUrl += '?' + querystring.stringify(options);

    return log(fetch)(requestUrl, { method: 'get', headers: req.context.headers })
        .then(response => response.json())
        .catch(error => {});
}

module.exports = getActions;
