const fetch = require('node-fetch');
const log = require('../common/log');

/**
 * Получить детальную информацию по лицензиям для заданного сервиса
 * @param {Express.Request} req
 * @param {String | Number} orgId
 * @param {String} serviceSlug
 * @returns {Promise<Array>}
 */
module.exports = (req, orgId, serviceSlug) => {
    const apiHost = req.context.config.api.directory;
    const requestUrl = `${apiHost}/admin/organizations/${orgId}/services/${serviceSlug}/licenses`;

    return log(fetch)(requestUrl, { method: 'get', headers: req.context.headers })
        .then(response => response.json())
        .then(data => Object.entries(data).map(([date, value]) => ({ ...value, date })))
        .catch(() => []);
};
