const fetch = require('node-fetch');
const log = require('../common/log');

function getSyncDetails(req, res, orgId) {
    let requestUrl = `${req.context.config.api.directory}/admin/organizations/${orgId || req.params.org_id}/maillists/sync/`;
    return log(fetch)(requestUrl, { method: 'get', headers: req.context.headers })
        .then(response => response.json())
        .catch(error => []);
}

module.exports = getSyncDetails;
