const fs = require('fs');
const path = require('path');

// порядок ключей дат должен соответствовать типичному порядку
// соответствующих им событий
const TIMELINE_DATES = [
    'enabled_at', 'ready_at', 'last_mail_sent_at', 'trial_expires',
    'disabled_at', 'expires_at'
];

const TIMELINE_FLAG_MAP = {
    ready_at: 'ready',
    enabled_at: 'enabled',
    disabled_at: 'enabled',
    trial_expires: 'trial_expired',
    expires_at: 'expires'
};

const TIMELINE_TAG_MAP = {
    disabled_at: 'disable_reason'
};

const TIMELINE_ICON_MAP = {
    expires_at: '⛔'
};

const DEFAULT_ICON_URL = '/res/services/default.svg';

function preprocessService(req, data) {
    if (!data || data._preprocessed)
        return data || {};

    /*
    if (data.paid_by_license) {
        data.expires_at = '2018-11-24';
        data.user_limit = 13;
    }
    */

    data.timeline = TIMELINE_DATES.slice()
        .map(key => {
            let item = data[key] ? { date: data[key] } : null;
            if (item) {
                let flagKey = TIMELINE_FLAG_MAP[key];

                item.flag = { key: flagKey, value: data[flagKey] };
                item.key = key;
                item.future = (new Date(item.date)).getTime() > Date.now();

                if (TIMELINE_TAG_MAP[key])
                    item.tag = data[TIMELINE_TAG_MAP[key]];

                if (TIMELINE_ICON_MAP[key])
                    item.icon = TIMELINE_ICON_MAP[key];
            }
            return item;
        })
        .filter(Boolean)
        .sort((a, b) => {
            let time = [a, b].map(item => (new Date(item.date)).getTime());

            // если времена для двух статусов одинаковые,
            // то смотрим по массиву TIMELINE_DATES, какой статус обычно идёт раньше
            if (time[0] === time[1]) {
                let weight = [
                    TIMELINE_DATES.indexOf(a.key),
                    TIMELINE_DATES.indexOf(b.key)
                ].map(value => value < 0 ? value : TIMELINE_DATES.length - value);

                return weight[0] === weight[1] ? 0 : (weight[0] < weight[1] ? 1 : -1);
            }

            return time[0] === time[1] ? 0 : (time[0] < time[1] ? -1 : 1);
        });

    /*
    data.icon = `/res/services/${data.slug}.svg`;

    if (!fs.existsSync(path.join(process.cwd(), 'compiled', data.icon)))
        data.icon = DEFAULT_ICON_URL;
    */

    data._preprocessed = true;

    return data;
}

module.exports = preprocessService;
