const i18n = require('./common/i18n');

function getCompoundName(data, options) {
    if (data && data.name && typeof data.name === 'object') {
        let locale = i18n.getLocale(options);
        return data.name[locale] || data.name.ru;
    }
    return data ? data.name : undefined;
}

function getSafeName(data) {
    return getCompoundName(data) || (data ? '#' + (data.id || '') : '');
}

module.exports = {
    getCompoundName,
    getSafeName
};
