const fs = require('fs');
const pathUtil = require('path');

// source: https://stat.yandex-team.ru/DictionaryEditor/BlockStat
const blockStatDictionary = require('./blockstat_dictionary.json');
const keyMap = require('./key_map.json');
const config = require('../../config');

const DEFAULT_GEO_ID = '213'; // Москва по геобазе

function getInitData(req) {
    const pageId = config.rum.service_id
        .split('.')
        .concat(req.context.page_id.split(/[\._]/g))
        .map(pageIdComponent => blockStatDictionary[pageIdComponent])
        .join('.');

    return [{
        beacon: true,
        clck: config.rum.counter_url,
        slots: [], // в отсутсвие a/b-экспериментов - пустой массив
        reqid: req.get('x-request-id'),
        crossOrigin: ''
    }, {
        // фиксируем идентификатор региона, пока нет необходимости
        // в статистике по регионам и подключении геобазы
        [keyMap.GEO_ID]: DEFAULT_GEO_ID,
        [keyMap.APP_PAGE_ID]: pageId
    }].map(item => JSON.stringify(item));
}

// https://github.yandex-team.ru/RUM/rum-counter#Инлайновый-код
const INLINE_SCRIPTS = [
    '@yandex-int/rum-counter/dist/inline/interface.min.js',
    '@yandex-int/rum-counter/dist/inline/longtask.min.js',
    '@yandex-int/rum-counter/dist/inline/io.min.js'
];

module.exports = req => {
    const inlineScripts = INLINE_SCRIPTS
        .map(src => ({
            src,
            content: fs.readFileSync(pathUtil.join(__dirname, `../../node_modules/${src}`))
                .toString()
                .trim()
        }));

    return {
        debug: req.query['rum-debug'] !== undefined,
        init: getInitData(req),
        inline_scripts: inlineScripts
    };
};
