const DAY = 86400; // seconds per day

export function setCookie(name, value, days) {
    let cookie = `${name}=${value}; path=/`;

    if (days) {
        cookie += `; max-age=${days * DAY}`;
    }

    document.cookie = cookie;
}

export function getCookie(name) {
    let parts = document.cookie.split(/;\s*/);

    for (let i = 0; i < parts.length; i++) {
        if (parts[i].indexOf(`${name}=`) === 0) {
            let value = parts[i].split('=')[1];

            // https://tools.ietf.org/html/rfc6265#section-5.2
            // Remove any leading or trailing WSP characters from the name
            // string and the value string.
            return value && value.trim();
        }
    }
}

export function deleteCookie(name) {
    document.cookie = `${name}=; max-age=-1`;
}
