import Polling from './index';

// поллинг, который встанет на паузу, когда вкладка неактивна
export default class VisiblePolling extends Polling {
    constructor(...args) {
        super(...args);

        this._trackVisibility = () => {
            clearTimeout(this._resumeTimeout);

            if (document.visibilityState !== 'visible' && this.running) {
                this.paused = true;

                super.stop();
            }

            if (document.visibilityState === 'visible' && this.paused) {
                this.paused = false;
                this.running = true;

                // возобновляем поллинг после visibilitychange,
                // но не чаще, чем предусмотрено периодом поллинга
                let delay = this.polledAt ? Math.max(this.polledAt + this.getDelay() - Date.now(), 0) : 0;

                this._resumeTimeout = setTimeout(() => super.start(), delay);
            }
        };
    }

    start(mode) {
        if (!this.running) {
            document.addEventListener('visibilitychange', this._trackVisibility);
        }

        this.paused = document.visibilityState && document.visibilityState !== 'visible';
        this.running = true;

        return this.paused ? Promise.resolve() : super.start(mode);
    }

    stop() {
        if (this.running) {
            document.removeEventListener('visibilitychange', this._trackVisibility);
        }

        this.paused = false;

        return super.stop();
    }
}
