var React = require('react');
var BemMixin = require('./BemMixin');

var PropTypes = React.PropTypes;

var Attach = React.createClass({
    mixins: [BemMixin],
    displayName: 'Attach',

    blockDidMount: function(block) {
        block.on('change', function() {
            this.callHandler('change', {
                target: block,
                value: block.getVal(),
                files: block.elem('control').prop('files')
            });
        }.bind(this));
    }
});

// @ifdef DEBUG
Attach.propTypes = {
    button: PropTypes.string,
    disabled: PropTypes.bool,
    mod: PropTypes.string,
    name: PropTypes.string,
    onChange: PropTypes.func,
    placeholder: PropTypes.string,
    size: PropTypes.oneOf(['s', 'm', 'l', 'xl']),
    theme: PropTypes.oneOf(['islands'])
};
// @endif

Attach.propsMap = {
    mods: {
        disabled: null,
        theme: null,
        size: null
    },
    button: null,
    name: null,
    placeholder: ['noFileText']
};

Attach.defaultProps = {
    size: 'm',
    theme: 'islands'
};

module.exports = Attach;
