var BemInputMixin = {
    blockDidMount: function(block) {
        block
            .on('change', function() {
                this.callHandler('change', {
                    target: block,
                    value: block.getVal()
                });
            }.bind(this))
            .on({modName: 'focused', modVal: '*'}, function(event, data) {
                this.callHandler(data.modVal ? 'focus' : 'blur', {
                    target: block,
                    value: block.getVal()
                });
            }.bind(this))
            .bindTo('control', 'keydown', function(event) {
                this.callHandler('keyDown', {
                    target: block,
                    keyCode: event.which,
                    value: block.getVal()
                });
            }.bind(this))
            .bindTo('control', 'keyup', function(event) {
                this.callHandler('keyUp', {
                    target: block,
                    keyCode: event.which,
                    value: block.getVal()
                });
            }.bind(this));
    },

    focus: function() {
        this.block.elem('control').focus();

        return this;
    },

    blur: function() {
        this.block.elem('control').blur();

        return this;
    },

    select: function() {
        this.block.elem('control').select();

        return this;
    },

    value: function() {
        return this.block.getVal();
    }
};

module.exports = BemInputMixin;
