var React = require('react');
var BemMixin = require('./BemMixin');

var PropTypes = React.PropTypes;

var transformIcon = function(icon) {
    return {
        block: 'icon',
        mods: {
            action: icon.action
        },
        url: icon.url,
        content: icon.content
    }
};

var Button = React.createClass({
    displayName: 'Button',
    mixins: [BemMixin],

    blockDidMount: function(block) {
        block.on('click', function() {
            this.callHandler('click', {
                target: block,
                value: block.getVal()
            });
        }.bind(this));
    }
});

// @ifdef DEBUG
Button.propTypes = {
    checked: PropTypes.bool,
    disabled: PropTypes.bool,
    id: PropTypes.string,
    mod: PropTypes.string,
    name: PropTypes.string,
    onClick: PropTypes.func,
    pressed: PropTypes.bool,
    size: PropTypes.oneOf(['s', 'm', 'l', 'xl']),
    switcher: PropTypes.oneOf(['check', 'radio']),
    tabIndex: PropTypes.number,
    text: PropTypes.string,
    theme: PropTypes.oneOf(['islands']),
    title: PropTypes.string,
    type: PropTypes.oneOf(['link', 'submit']),
    url: PropTypes.string,
    val: PropTypes.oneOfType([
        PropTypes.string,
        PropTypes.number
    ]),
    view: PropTypes.oneOf(['action', 'pseudo', 'plain']),
    icon: PropTypes.object
};
// @endif

Button.propsMap = {
    mods: {
        checked: null,
        disabled: null,
        pressed: null,
        size: null,
        switcher: ['togglable'],
        theme: null,
        type: null,
        view: null
    },
    id: null,
    name: null,
    tabIndex: null,
    text: [null, 'setText'],
    title: null,
    url: [null, 'setUrl'],
    val: [null],
    icon: [null, null, transformIcon]
};

Button.defaultProps = {
    size: 'm',
    theme: 'islands'
};

module.exports = Button;
