var React = require('react');
var BemMixin = require('./BemMixin');

var PropTypes = React.PropTypes;

/**
 * Пример описания календаря в bem json
 * @example
 * {
 *  block: 'input',
 *  mods: {
 *      hasCalendar: true,
 *      size: 'm',
 *      theme: 'islands',
 *      readonly: true
 *  },
 *  weekdays: ['пн', 'вт', 'ср', 'чт', 'пт', 'сб', 'вс'],
 *  months: ['Январь', 'Февраль', 'Март',
 *      'Апрель', 'Май', 'Июнь',
 *      'Июль', 'Август', 'Сентябрь',
 *      'Октябрь', 'Ноябрь', 'Декабрь'],
 *  val: '11.11.2015'
 *  }
 * }
 * @see https://github.yandex-team.ru/search-interfaces/o2-calendar
 */

var Calendar = React.createClass({
    displayName: 'Calendar',

    blockName: 'input',

    blockDidMount: function(block) {
        block.on('change', this.handleChange);
    },

    handleChange: function() {
        this.callHandler('change', this.block.getVal());
    },

    componentWillReceiveProps: function(nextProps) {
        if (nextProps.val && nextProps.val !== this.props.val) {
            // Исключаем вызов обработчика изменения компонента
            this.block.un('change', this.handleChange);
            this.block.setVal(nextProps.val);
            // Возвращаем отслеживание обработчика обратно
            this.block.on('change', this.handleChange);
        }
    },

    mixins: [BemMixin]
});

// @ifdef DEBUG
Calendar.propTypes = {
    earlierLimit: PropTypes.string,
    hasCalendar: PropTypes.bool,
    laterLimit: PropTypes.string,
    months: PropTypes.array,
    size: PropTypes.oneOf(['s', 'm', 'l', 'xl']),
    readonly: PropTypes.bool,
    theme: PropTypes.oneOf(['islands']),
    val: PropTypes.string,
    weekdays: PropTypes.array
};
// @endif

Calendar.propsMap = {
    mods: {
        hasCalendar: null,
        size: null,
        theme: null,
        readonly: null
    },
    weekdays: null,
    months: null,
    val: null,
    earlierLimit: null,
    laterLimit: null
};

Calendar.defaultProps = {
    hasCalendar: true,
    size: 'm',
    theme: 'islands'
};

module.exports = Calendar;
