var React = require('react');
var BemMixin = require('./BemMixin');

var PropTypes = React.PropTypes;

var Checkbox = React.createClass({
    displayName: 'Checkbox',
    mixins: [BemMixin],

    blockDidMount: function(block) {
        block.on({modName: 'checked', modVal: '*'}, function(event, data) {
            this.callHandler('change', {
                target: block,
                checked: data.modVal === true,
                value: block.getVal()
            });
        }.bind(this));
    }
});

// @ifdef DEBUG
Checkbox.propTypes = {
    checked: PropTypes.bool,
    disabled: PropTypes.bool,
    id: PropTypes.string,
    text: PropTypes.string,
    mod: PropTypes.string,
    name: PropTypes.string,
    onChange: PropTypes.func,
    size: PropTypes.oneOf(['m', 'l']),
    tabIndex: PropTypes.number,
    theme: PropTypes.oneOf(['islands']),
    val: PropTypes.oneOfType([
        PropTypes.string,
        PropTypes.number
    ])
};
// @endif

Checkbox.propsMap = {
    mods: {
        checked: null,
        disabled: null,
        theme: null,
        size: null
    },
    id: null,
    text: null,
    name: null,
    tabIndex: null,
    val: null
};

Checkbox.defaultProps = {
    theme: 'islands',
    size: 'm'
};

module.exports = Checkbox;
